/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.tree;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeResourceNode;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.TaskContainerNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.tree.TreeNodeLight;
import com.ibm.psw.wcl.components.menu.IMenuItem;
import com.ibm.psw.wcl.components.menu.MenuInfo;
import com.ibm.psw.wcl.components.menu.MenuItemInfo;
import com.ibm.psw.wcl.components.menu.WPopupMenu;
import com.ibm.psw.wcl.components.tree.TreeCellInfo;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.renderers.tree.html.HTMLTreeCellRenderer;
import com.ibm.psw.wcl.skins.base.BaseCellStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseHyperlinkStyleInfo;
import java.util.Iterator;
import java.util.List;

public class TreeNodeCellRenderer
extends HTMLTreeCellRenderer {
    public static final String COPYRIGHT = "Licensed Materials-Property of IBM\nPS for the Web\n(C)Copyright IBM Corp 2000,2004\nAll rights reserved\nUS Govt Users Restricted Rights-Use,duplication,or disclosure restricted by GSA ADP Schedule Contract w/IBM Corp";

    public String getText(RenderingContext rc, CellInfo cellInfo) {
        Object val = cellInfo.getValue();
        if (val == null) {
            return String.valueOf(val);
        }
        if (val instanceof TreeNodeLight) {
            return ((TreeNodeLight)val).getName();
        }
        if (val instanceof TaskNode) {
            return ((TaskNode)val).getName();
        }
        return String.valueOf(val);
    }

    public DefaultHyperlinkCell prepareCell(RenderingContext rc, DefaultHyperlinkCell cell, TreeCellInfo cellInfo) {
        cell = super.prepareCell(rc, cell, cellInfo);
        int pathCount = cellInfo.getPath().getPathCount();
        if (cell instanceof DefaultHyperlinkCell) {
            WComponent comp;
            AStyleInfo style = cell.getStyleInfo(rc.getSkin());
            if (style == null) {
                style = new BaseCellStyleInfo();
                cell.setStyleInfo(style);
            }
            cell.getHyperlink().setStyleInfo(null);
            AStyleInfo hyperlinkStyle = cell.getHyperlink().getStyleInfo(rc.getSkin());
            if (hyperlinkStyle == null) {
                hyperlinkStyle = new BaseHyperlinkStyleInfo();
                cell.getHyperlink().setStyleInfo(hyperlinkStyle);
            }
            if (pathCount == 2) {
                hyperlinkStyle.setStyleValue("lnk1", "text-decoration", (Object)"none");
                hyperlinkStyle.setStyleValue("lnk1", "font-weight", (Object)"bold");
                hyperlinkStyle.setStyleValue("lnk1", "font-family", (Object)"Arial, Helvetica, sans-serif");
                hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
                hyperlinkStyle.setStyleValue("lnk1", "color", (Object)"#2C567F");
            } else {
                hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
                hyperlinkStyle.setStyleValue("lnk1", "color", (Object)"#2C567F");
            }
            Object val = cellInfo.getValue();
            String id = null;
            if (val != null && val instanceof TreeNodeLight) {
                id = ((TreeNodeLight)val).getId();
            } else if (val != null && val instanceof TaskNode) {
                id = cell.getID();
            }
            if (cellInfo.getSelected() && id != null) {
                if (rc.getSession(false) == null) {
                    throw new IllegalStateException("Error retrieving the session from the rendering context.!");
                }
                HMCSession hmcSession = HMCSession.getHMCSession(rc.getSession(false));
                if (hmcSession == null) {
                    throw new IllegalStateException("No HMC session!");
                }
                BonsaiTreeNode selectedNode = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id);
                if (selectedNode instanceof BonsaiTreeResourceNode) {
                    UISession uis = UISession.getUISession(hmcSession);
                    List lTaskNodes = null;
                    lTaskNodes = selectedNode instanceof Targetable ? TaskManager.getTaskManager().getTasksWithTargets((TaskContainerNode)selectedNode, uis) : TaskManager.getTaskManager().getTasks((TaskContainerNode)selectedNode, uis);
                    MenuInfo root = new MenuInfo();
                    this.buildMenuItems(root, lTaskNodes);
                    if (root.getChildCount() > 0) {
                        WPopupMenu popup = new WPopupMenu((IMenuItem)root);
                        popup.setID("BonsaiContextMenuId");
                        popup.setVisible(true);
                        cell.add((WComponent)popup);
                    }
                }
            }
            if (!cellInfo.getSelected() && (comp = cell.findChildComponent("BonsaiContextMenuId")) != null) {
                cell.remove(comp);
            }
        }
        return cell;
    }

    private void buildMenuItems(MenuInfo root, List lTaskNodes) {
        TaskNode tNode = null;
        Iterator iter = lTaskNodes.iterator();
        while (iter.hasNext()) {
            tNode = (TaskNode)iter.next();
            List lTaskNodeChildren = tNode.getChildren();
            if (lTaskNodeChildren != null && lTaskNodeChildren.size() > 0) {
                MenuInfo group = new MenuInfo(tNode.getName());
                root.addChild((IMenuItem)group);
                this.buildMenuItems(group, lTaskNodeChildren);
                continue;
            }
            String str = tNode.getName();
            if (str != null) {
                str = str.replace('\n', ' ');
            }
            MenuItemInfo mi = new MenuItemInfo();
            mi.setText(str);
            mi.setOnClick("document.location.href = '" + tNode.getUrlString() + "';top.window.frames['hmcmainui']." + "frames['navigation_frame']" + ".document.location.reload()");
            root.addChild((IMenuItem)mi);
        }
    }

    private void buildCompactMenuItems(MenuInfo root, List lTaskNodes, String spacer) {
        TaskNode tNode = null;
        Iterator iter = lTaskNodes.iterator();
        while (iter.hasNext()) {
            tNode = (TaskNode)iter.next();
            List lTaskNodeChildren = tNode.getChildren();
            String str = tNode.getName();
            if (str != null) {
                str = str.replace('\n', ' ');
            }
            MenuItemInfo mi = new MenuItemInfo();
            mi.setText(spacer + str);
            root.addChild((IMenuItem)mi);
            if (lTaskNodeChildren != null && lTaskNodeChildren.size() > 0) {
                this.buildCompactMenuItems(root, lTaskNodeChildren, spacer + "_| ");
                continue;
            }
            mi.setOnClick("document.location.href = '" + tNode.getUrlString() + "';top.window.frames['hmcmainui']." + "frames['navigation_frame']" + ".document.location.reload()");
        }
    }
}

